% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rgeo_vario_construct_plot.R
\name{Rgeo_vario_construct_plot}
\alias{Rgeo_vario_construct_plot}
\title{Experimental Ominidirectional Variogram Plot using Regostats}
\usage{
Rgeo_vario_construct_plot(db, num_fac, property, lag, nlag = 10)
}
\arguments{
\item{db}{The db-class containing the data information used to calculate the experimental variogram.
The variograms are calculated for the set of "z*" variables present in the db.}

\item{num_fac}{A numeric value indicating how many factors to analyze. Default is 3.}

\item{property}{A string indicating which factor to build variogram from e.g. "RC1" or "RC2"}

\item{lag}{Array containing the distance lags for each calculation direction.
If the lag is not defined, set as NA.
A default lag is calculated so that the maximum distance is equal to half of the field diagonal}

\item{nlag}{Array containing the number of lags for each calculation direction
If nlag not defined, set as NA.
If the number of lags is not defined, it defaults to 10.}
}
\value{
a plottable Rgeostats Experimental Ominidirectional Variogram model
}
\description{
This function constructs an Experimental Ominidirectional Variogram using 'Rgeostats'.
}
\examples{
if(requireNamespace("RGeostats")){
    library(RGeostats)
    data("Klovan_Row80", package = "klovan")
    db <- Rgeo_database(Klovan_Row80, 3, "RC3")
    Rgeo_vario_construct_plot(db, 3, "RC3", lag = 500)
}
}
