% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_data}
\alias{generate_data}
\title{generate response from nonparametric additive model}
\usage{
generate_data(X, reg_coef, model = "linear", err_sd = 1)
}
\arguments{
\item{X}{design matrix of additive model; rows are observations and columns are variables.}

\item{reg_coef}{regression coefficient vector.}

\item{model}{types of components. Default is "linear". Other choices are
\tabular{ll}{
\code{linear}  \tab  linear regression.  \cr
\code{poly}  \tab   polynomial of degree sampled from 2 to 4. \cr
\code{sinpoly} \tab sum of polynomial of sin and cos. \cr
\code{sinratio}  \tab  ratio of sin. \cr
\code{sinmix} \tab   sampled from poly and sinratio. \cr
}}

\item{err_sd}{standard deviation of regression error.}
}
\value{
reponse vector
}
\description{
The function generate response from additive models of various components.
}
\examples{
p=5 # number of predictors
s=2  # sparsity, number of nonzero component functions
sig_mag=100 # signal strength
n= 200 # sample size
model="poly" # component function type
X=matrix(rnorm(n*p),n,p) \%*\%chol(toeplitz(0.3^(0:(p-1))))   # generate design
reg_coef=c(rep(1,s),rep(0,p-s))  # regression coefficient
reg_coef=reg_coef*(2*(rnorm(p)>0)-1)*sig_mag
y=generate_data(X,reg_coef,model) # reponse vector


}
\author{
Xiaowu Dai, Xiang Lyu, Lexin Li
}
