% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kitesquare.R
\name{kitesquare}
\alias{kitesquare}
\title{Create a kite-square plot}
\usage{
kitesquare(
  df,
  x,
  y,
  obs,
  normalize = FALSE,
  full_range = FALSE,
  center_x = TRUE,
  center_y = TRUE,
  center = NULL,
  fill_x = FALSE,
  fill_y = FALSE,
  fill = NULL,
  kite = TRUE,
  spars = TRUE,
  square = TRUE,
  chi2 = TRUE,
  bars_x = TRUE,
  bars_y = TRUE,
  bars = NULL,
  intersect_x = TRUE,
  intersect_y = TRUE,
  intersect = NULL,
  color_x = "#e31a1c",
  color_y = "#1f78b4",
  kite_color = "black",
  square_color = "black",
  spars_color = "black",
  chi2_color = "#bebebe",
  border_color = "black",
  alpha_fill = 0.3,
  alpha_chi2 = 0.3,
  alpha = NULL,
  pointsize = 3,
  linewidth = 1,
  whisker_length = 0.05,
  extend_whiskers = FALSE,
  dodge_x = 2,
  ...
)
}
\arguments{
\item{df}{A tibble or data frame of observations.}

\item{x, y}{Name of the variable in \code{df} for x (columns) and y (rows), as string or expression.}

\item{obs}{Name of observation counts in \code{df}. If a combination of \code{y} and \code{x} appears multiple times in \code{df}, \code{obs} are added together. If not provided, a value of 1 will be assumed for each line in \code{df}.}

\item{normalize}{Should values te normalized to probabilities and expressed in percent?}

\item{full_range}{If \code{normalize} is TRUE, should all axes limits be from 0 to 1?}

\item{center_x, center_y, center}{Should a binary x or y variable be centered (axis reversed) so that the spars meet? \code{center} overrides both.}

\item{fill_x, fill_y, fill}{Should the space between x or y bars and the axis be filled? \code{fill} overrides both.}

\item{kite, square, spars, chi2}{Should the kite, square, spars and \eqn{\chi^2} patches be drawn?}

\item{bars_x, bars_y, bars}{Should the bars for the x and y variables be drawn? \code{bars} overrides both.}

\item{intersect_x, intersect_y, intersect}{Should the intersect positions for x and y variables with their axes be drawn? \code{intersect} overrides both.}

\item{color_x, color_y}{Colors for x and y.}

\item{kite_color, square_color, spars_color, chi2_color}{Color of the kite, square, spars and \eqn{\chi^2} patches.}

\item{border_color}{Color for the border around each cell.}

\item{alpha_fill, alpha_chi2, alpha}{Transparency for fill and \eqn{\chi^2} patches. \code{alpha} overrides both.}

\item{pointsize}{The point size for intersects and spars.}

\item{linewidth}{The line width for bars and spars.}

\item{whisker_length}{The length of bar whiskers.}

\item{extend_whiskers}{Should the bar whiskers be extended to wrap around the \eqn{\chi^2} patches?}

\item{dodge_x}{The number of levels the x axis labels should dodge.}

\item{...}{Further arguments passed to ggplot2::facet_grid().}
}
\value{
A ggplot object, with an extra $table key. The latter contains the tibble of coordinates created internally for plotting.
}
\description{
Given a data frame or tibble, creates a kite-square plot to visualize the contingency table of two discrete variables.
}
\examples{
df <- dplyr::tibble(
  X=c('A', 'A', 'B', 'B', 'B'),
  Y=c('U', 'V', 'U', 'V', 'V'),
  count=c(30,15,30,70,65))
kitesquare(df, X, Y, count)
kitesquare(df, X, Y, count, normalize=TRUE, center_x=FALSE)
}
