% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KinPairSimulation.R
\name{KinPairSimulation_simple}
\alias{KinPairSimulation_simple}
\title{Constructor for KinPairSimulation Class (simple)}
\usage{
KinPairSimulation_simple(
  data = NULL,
  kinship = NULL,
  kerneltype = NULL,
  posigma = NULL,
  simdims = NULL,
  lifestage = NULL,
  kernelshape = NULL,
  call = NULL,
  model = NULL
)
}
\arguments{
\item{data}{tibble of pairwise kin classes & distances. Ideally contains fields id1 & id2 (chr) an distance (dbl) optionally includes coords (x1, y1, x2, y2), lifestage (ls1 & ls2), kinship (chr) and sims (dbl)}

\item{kinship}{character. Code for kinship category of simulation. one of PO, FS, HS, AV, GG, HAV, GGG, 1C, 1C1, 2C, GAV, HGAV, H1C or H2C}

\item{kerneltype}{character. Statistical model for simulated dispersal kernel. Currently either "Gaussian", "Laplace" or "vgamma" (variance-gamma).}

\item{posigma}{numeric. Axial sigma of dispersal kernel (axial standard deviation).}

\item{simdims}{numeric. Length of side of simulated area square.}

\item{lifestage}{character. Simulated lifestage of sampling. Either "immature" (sampled at hatching) or "ovipositional"
(sampled as an adult during oviposition - essentially one lifespan later than 'immature')}

\item{kernelshape}{numeric. Value of shape parameter for simulated kernel if kernel requires one (e.g. vgamma kernel).}

\item{call}{call object. Use to pass the system call that led to the generation of this class. (via sys.call)}

\item{model}{DispersalModel - model information passed from simulation function}
}
\value{
Returns a \code{KinPairSimulation} Class object with simtype set to 'simple' and relevant fields included.
}
\description{
Constructor for KinPairSimulation Class (simple)
}
\examples{
kindata <- tibble::tibble(
  id1 = c("a", "b", "c"), id2 = c("x", "y", "z"),
  distance = c(50, 45, 65), kinship = c("1C", "1C", "1C")
)
KinPairSimulation_simple(kindata,
  kinship = "1C", kerneltype = "Gaussian",
  posigma = 38, lifestage = "immature"
)
}
