% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_fas.R
\name{egfr.fas.cys}
\alias{egfr.fas.cys}
\title{Calculate eGFR by the Full age spectrum (FAS) cystatin-based equation}
\usage{
egfr.fas.cys(
  cystatin,
  age,
  cystatin_units = "mg/L",
  equation_type = "precise",
  max_age = 100
)
}
\arguments{
\item{cystatin}{Numeric vector. Serum cystatin, could be expressed in "mg/L" or "nanomol/L". Units of measurement should be defined in variable cystatin_units (if not defined explicitly by user, the default value is "mg/L").}

\item{age}{Numeric vector. Age, in years.}

\item{cystatin_units}{Character string. Units in which serum cystatin is expressed. Could be one of the following: "mg/L" or "nanomol/L"}

\item{equation_type}{Character string. Whether to use "precise" or "simplified" equation.}

\item{max_age}{Numeric. Maximal age suitable for the equation application, in years. By default is 100 years, but change this value in case you would like to apply equation to older persons.}
}
\value{
numeric eGFR expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate eGFR by the Full age spectrum (FAS) cystatin-based equation
}
\details{
Calculate estimated glomerular filtration rate (eGFR) by the Full age spectrum (FAS) cystatin-based equation.

Reference to the equation: Pottel H, Delanaye P, Schaeffner E et al. Estimating glomerular filtration rate for the full age spectrum from serum creatinine and cystatin C. Nephrol Dial Transplant 2017; 32:497–507 doi:10.1093/ndt/gfw425.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
egfr.fas.cys (cystatin = 0.8, age = 60)
# for a dataset - see vignettes for details
# egfr.fas.cys (cystatin = dta$cys, age = dta$age)
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
