% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_all_adults.R
\name{egfr.all_adults.cr_cys}
\alias{egfr.all_adults.cr_cys}
\title{Calculate eGFR by all creatinine-cystatin-based equations for adults}
\usage{
egfr.all_adults.cr_cys(
  creatinine,
  cystatin,
  age,
  sex,
  creatinine_units = "micromol/l",
  cystatin_units = "mg/L",
  label_sex_male = c("Male", 1),
  label_sex_female = c("Female", 0),
  max_age = 100
)
}
\arguments{
\item{creatinine}{Numeric vector. Serum creatinine, could be expressed in "micromol/L", "mmol/L" or "mg/dL". Units of measurement should be defined in variable creatinine_units (if not defined explicitly by user, the default value is "micromol/L").}

\item{cystatin}{Numeric vector. Serum cystatin, could be expressed in "mg/L" or "nanomol/L". Units of measurement should be defined in variable cystatin_units (if not defined explicitly by user, the default value is "mg/L").}

\item{age}{Numeric vector. Age, in years.}

\item{sex}{Vector. The value of variable refers to the parameters label_sex_male and label_sex_female.}

\item{creatinine_units}{Character string. Units in which serum creatinine is expressed. Could be one of the following: "micromol/L", "mmol/L" or "mg/dL".}

\item{cystatin_units}{Character string. Units in which serum cystatin is expressed. Could be one of the following: "mg/L" or "nanomol/L"}

\item{label_sex_male}{List. Label(s) for definition(s) of male sex.}

\item{label_sex_female}{List. Label(s) for definition(s) of female sex.}

\item{max_age}{Numeric. Maximal age suitable for the equation application, in years. By default is 100 years, but change this value in case you would like to apply equation to older persons.}
}
\value{
numeric eGFR expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate eGFR by all creatinine-cystatin-based equations for adults
}
\details{
Calculate eGFR by all creatinine-cystatin-based equations for adults available in the kidney.epi package.

References to the equations are available in single functions of the kidney.epi package.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
