% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_functions.R
\name{doutlier}
\alias{doutlier}
\title{doutlier defines an outlier distribution (Surface of a
trapezium) and uses input parameters given in the main function kfino_fit()}
\usage{
doutlier(y, K, expertMin, expertMax)
}
\arguments{
\item{y}{numeric, point}

\item{K}{numeric, constant value}

\item{expertMin}{numeric, the minimal weight expected by the user}

\item{expertMax}{numeric, the maximal weight expected by the user}
}
\value{
a numeric value
}
\description{
doutlier defines an outlier distribution (Surface of a
trapezium) and uses input parameters given in the main function kfino_fit()
}
\details{
this function is used to calculate an outlier distribution
         following a trapezium shape. 
 \eqn{y \mapsto \text{doutlier}(y,K,\text{expertMin},\text{expertMax})}
         is the probability density function on 
 \eqn{[\text{expertMin},\text{expertMax}]} which is linear and verifies
 \eqn{\text{doutlier}(\text{expertMax},K,\text{expertMin},\text{expertMax}) 
 =K*\text{doutlier}(\text{expertMin},K,\text{expertMin},\text{expertMax}).}
 In particular, when $K=1$ this corresponds to the uniform distribution.
}
\examples{
doutlier(2,5,10,45)
}
