% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_kc_account.R
\name{get_kc_account}
\alias{get_kc_account}
\title{Get a account name from macOS Keychain using the 'security' cli}
\usage{
get_kc_account(label, type = "generic")
}
\arguments{
\item{label}{Keychain password label}

\item{type}{Leychain password type.  Either "generic" or "internet".}
}
\value{
Returns the account value attached to the label.

macOS may require the user to grant access to "security" the first time the function
is run for each stored credential.  It is important to select "Always allow", which will
prevent similar dialogs in the future.
}
\description{
Get a account name from macOS Keychain using the 'security' cli
}
\examples{
\dontrun{
# First store a set of credentials in Keychain
# now return the account name to the R environment
x <- get_kc_account("label")
}

}
