% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beir.R
\name{Beir}
\alias{Beir}
\alias{Beir.default}
\alias{Bei}
\alias{Ber}
\title{Fundamental solution to the Kelvin differential equation (J)}
\usage{
Beir(x, ...)

\method{Beir}{default}(x, nu. = 0, nSeq. = 1, return.list = FALSE, ...)

Bei(...)

Ber(...)
}
\arguments{
\item{x}{numeric; values to evaluate the complex solution at}

\item{...}{additional arguments passed to \code{\link[Bessel]{BesselK}} or \code{\link{Beir}}}

\item{nu.}{numeric; value of \eqn{\nu} in \eqn{\mathcal{B}_\nu}{Bei,Ber} solutions}

\item{nSeq.}{positive integer; equivalent to \code{nSeq} in \code{\link[Bessel]{BesselJ}}}

\item{return.list}{logical; Should the result be a list instead of matrix?}
}
\value{
If \code{return.list==FALSE} (the default),
a complex matrix with as many columns as using \code{nSeq.} creates.
Otherwise the result is a list with matrices for
Real and Imaginary components.
}
\description{
This function calculates the complex solution to the Kelvin differential
equation using modified Bessel functions of the \emph{first kind}, specifically
those produced by \code{\link[Bessel]{BesselJ}}.
}
\details{
\code{\link{Ber}} and \code{\link{Bei}} are wrapper functions
which return the real and imaginary components of \code{\link{Beir}}, respectively.
}
\examples{

Beir(1:10)    # defaults to nu.=0
Beir(1:10, nu.=2)
Beir(1:10, nSeq.=2)
Beir(1:10, nSeq.=2, return.list=TRUE)


# Imaginary component only
Bei(1:10)

# Real component only
Ber(1:10)
}
\references{
\url{https://mathworld.wolfram.com/KelvinFunctions.html}

Imaginary: \url{https://mathworld.wolfram.com/Bei.html}

Real: \url{https://mathworld.wolfram.com/Ber.html}
}
\seealso{
\code{\link{kelvin-package}}, \code{\link{Keir}}, \code{\link[Bessel]{BesselJ}}
}
\author{
Andrew Barbour
}
