% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{runUMAP}
\alias{runUMAP}
\title{Cluster matrix data by UMAP}
\usage{
runUMAP(
  TapestriExperiment,
  alt.exp = "alleleFrequency",
  assay = NULL,
  use.pca.dims = TRUE,
  pca.dims = NULL,
  ...
)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object}

\item{alt.exp}{Character, \code{altExp} to use, \code{NULL} uses top-level/main experiment. Default "alleleFrequency".}

\item{assay}{Character, \code{assay} to use. \code{NULL} (default) uses first-indexed assay. Not used when \code{use.pca.dims = TRUE}.}

\item{use.pca.dims}{Logical, if \code{TRUE}, uses experiment PCA, otherwise uses \code{assay} data. Default \code{TRUE}.}

\item{pca.dims}{Numeric, indices of PCs to use in UMAP. Default \code{NULL}.}

\item{...}{Additional parameters to pass to \code{\link[umap:umap]{umap::umap()}}, e.g. for configuration (see \code{\link[umap:umap.defaults]{umap::umap.defaults()}}).}
}
\value{
\code{TapestriExperiment} with UMAP embeddings saved to \code{reducedDims} slot of \code{altExp.}
}
\description{
Analyzes matrix data by UMAP and saves results to \code{reducedDims} slot of \code{TapestriObject}.
}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
tap.object <- runPCA(tap.object, alt.exp = "alleleFrequency")
tap.object <- runUMAP(tap.object, pca.dims = 1:3)
}
\concept{dimensional reduction}
