% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{assayHeatmap}
\alias{assayHeatmap}
\title{Generate heatmap of assay data}
\usage{
assayHeatmap(
  TapestriExperiment,
  alt.exp = NULL,
  assay = NULL,
  split.col.by = NULL,
  split.row.by = NULL,
  annotate.row.by = NULL,
  color.preset = NULL,
  color.custom = NULL,
  ...
)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object}

\item{alt.exp}{Character, \code{altExp} slot to use. \code{NULL} (default) uses top-level/main experiment.}

\item{assay}{Character, \code{assay} slot to use. \code{NULL} (default) uses first-indexed assay (usually "counts").}

\item{split.col.by}{Character, \code{rowData} column to split columns by, i.e. "chr" or "arm". Default \code{NULL}.}

\item{split.row.by}{Character, \code{colData} column to split rows by, i.e. "cluster". Default \code{NULL}.}

\item{annotate.row.by}{Character, \code{colData} column to use for block annotation. Default \code{NULL}.}

\item{color.preset}{Character, color preset to use for heatmap color, either "copy.number" or "copy.number.denoise" (see \code{Details}). Overrides \code{color.custom}. \code{NULL} (default) uses default \code{ComplexHeatmap} coloring.}

\item{color.custom}{Color mapping function given by \code{\link[circlize:colorRamp2]{circlize::colorRamp2()}}. \code{color.preset} must be \code{NULL}.}

\item{...}{Additional parameters to pass to \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}.}
}
\value{
A \code{ComplexHeatmap} object
}
\description{
Creates a heatmap of data from the indicated \code{TapestriObject} \code{assay} slot using the \code{ComplexHeatmap} package.
Heatmaps are generated as transposed (i.e. x-y flipped) representations of the \code{assay} matrix.
Additional \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}} parameters can be passed in to overwrite defaults.
}
\section{Options for \code{color.preset}}{
\subsection{"copy.number"}{

Blue-white-red gradient from 0-2-4. 4 to 8+ is red-black gradient.

\if{html}{\out{<div class="sourceCode">}}\preformatted{circlize::colorRamp2(c(0,1,2,3,4,8),
c('#2c7bb6','#abd9e9','#ffffff','#fdae61','#d7191c', "black"))
}\if{html}{\out{</div>}}
}

\subsection{"copy.number.denoise"}{

Similar to 'copy.number' present, but white range is from 1.5-2.5 to reduce the appearance of noise around diploid cells.

\if{html}{\out{<div class="sourceCode">}}\preformatted{circlize::colorRamp2(c(0,1,1.5,2,2.5,3,4,8),
c('#2c7bb6','#abd9e9','#ffffff','#ffffff','#ffffff','#fdae61','#d7191c', "black"))
}\if{html}{\out{</div>}}
}
}

\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
assayHeatmap(tap.object,
  assay = "counts", split.row.by = "test.cluster",
  annotate.row.by = "test.cluster", split.col.by = "chr"
)
}
\seealso{
\link[ComplexHeatmap]{Heatmap}
}
\concept{plots}
