% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/apportion.R
\docType{methods}
\name{apportion}
\alias{apportion}
\alias{apportion-method}
\alias{apportion,data.frame-method}
\alias{apportion,matrix-method}
\title{Chronological Apportioning}
\usage{
apportion(object, ...)

\S4method{apportion}{data.frame}(
  object,
  s0,
  s1,
  t0,
  t1,
  from = min(s0),
  to = max(s1),
  step = 25,
  method = c("uniform", "truncated"),
  z = 2,
  progress = getOption("kairos.progress")
)

\S4method{apportion}{matrix}(
  object,
  s0,
  s1,
  t0,
  t1,
  from = min(s0),
  to = max(s1),
  step = 25,
  method = c("uniform", "truncated"),
  z = 2,
  progress = getOption("kairos.progress")
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Currently not used.}

\item{s0}{A length-\eqn{m} \code{\link{numeric}} vector giving the site beginning dates
expressed in CE years (BCE years must be given as negative numbers).}

\item{s1}{A length-\eqn{m} \code{\link{numeric}} vector giving the site end dates
expressed in CE years (BCE years must be given as negative numbers).}

\item{t0}{A length-\eqn{p} \code{\link{numeric}} vector giving the type beginning dates
expressed in CE years (BCE years must be given as negative numbers).}

\item{t1}{A length-\eqn{p} \code{\link{numeric}} vector giving the type end dates
expressed in CE years (BCE years must be given as negative numbers).}

\item{from}{A length-one \code{\link{numeric}} vector giving the beginning of the
period of interest (in years CE).}

\item{to}{A length-one \code{\link{numeric}} vector giving the end of the period of
interest (in years CE).}

\item{step}{A length-one \code{\link{integer}} vector giving the step size, i.e. the
width of each time step for apportioning (in years CE; defaults to
\eqn{25}).}

\item{method}{A \code{\link{character}} string specifying the distribution to be used
(type popularity curve). It must be one of "\code{uniform}" (uniform
distribution) or "\code{truncated}" (truncated standard normal distribution).
Any unambiguous substring can be given.}

\item{z}{An \code{\link{integer}} value giving the lower and upper truncation points
(defaults to \eqn{2}). Only used if \code{method} is "\code{truncated}".}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar be displayed?}
}
\value{
A \code{\linkS4class{CountApportion}} object.
}
\description{
Chronological Apportioning
}
\examples{
## Replication of Roberts et al. 2012
bayless <- matrix(
  data = c(4, 333, 11, 11, 13, 1605, 252, 9, 48), nrow = 1,
  dimnames = list(c("Bayless"), c("CWW", "CBW", "LMGRW", "LTB", "MMS",
                                  "PBW", "RRW", "SCBW", "TBBW"))
)

## Set ware start and end dates
start <- c(550, 800, 1200, 1150, 1275, 200, 1275, 1200, 750)
end <- c(1325, 1400, 1450, 1300, 1400, 1450, 1450, 1450, 1300)

## Apportion ceramic assemblage under flat/uniform distribution
app <- apportion(bayless, s0 = 1200, s1 = 1350, t0 = start, t1 = end,
                 step = 50, method = "uniform")

## Apportion ceramic assemblage under truncated standard normal distribution
app <- apportion(bayless, s0 = 1200, s1 = 1350, t0 = start, t1 = end,
                 step = 50, method = "truncated", z = 2)

## Array of results
head(app)
}
\references{
Roberts, J. M., Mills, B. J., Clark, J. J., Haas, W. R., Huntley, D. L. &
Trowbridge, M. A. (2012). A Method for Chronological Apportioning of Ceramic
Assemblages. \emph{Journal of Archaeological Science}, 39(5): 1513-20.
\doi{10.1016/j.jas.2011.12.022}.
}
\seealso{
Other chronological analysis: 
\code{\link{fit}()}
}
\author{
N. Frerebeau
}
\concept{chronological analysis}
\concept{chronological apportioning methods}
