% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jjcs_num_formats.R
\name{jjcs_num_formats}
\alias{jjcs_num_formats}
\title{Numeric Formatting Function}
\usage{
jjcs_num_formats(d, cap = 4)
}
\arguments{
\item{d}{(\code{numeric})\cr precision of individual values}

\item{cap}{(\code{numeric})\cr cap to numerical precision (d > cap --
will use precision as if cap was specified as precision)}
}
\value{
list:
\itemize{
\item fmt : named vector with formatting function (jjcsformat_xx) for numerical stats: range, median, mean_sd, sd
\item spec : named vector with formatting specifications for numerical stats: range, median, mean_sd, sd
}
}
\description{
Formatting setter for selected numerical statistics.
}
\examples{
P1_precision <- jjcs_num_formats(d = 0)$fmt
jjcs_num_formats(2)$fmt
jjcs_num_formats(2)$spec
}
