% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_convert.R
\name{mesh_convert}
\alias{mesh_convert}
\title{Mesh unit converter}
\usage{
mesh_convert(meshcode = NULL, to_mesh_size = NULL)
}
\arguments{
\item{meshcode}{\code{character}. mesh code}

\item{to_mesh_size}{target mesh size.
That is, 1 for 1km, and 0.5 for 500m. From 80km to 0.100km.}
}
\value{
\link{meshcode}
}
\description{
Return different meshcode values included in the mesh.
}
\details{
If \code{NULL} for to_mesh_size, the meshcode of one small
scale will be returned. If it is the same as the original size,
the meshcode of the input will be return.
}
\examples{
mesh_convert(meshcode = "52350432", to_mesh_size = 80)
mesh_convert("52350432", 10)
# Scale down
mesh_convert("52350432", 0.500)
mesh_convert("52350432", 0.250)
mesh_convert(meshcode = "52350432", 0.125)
mesh_convert("523504323", 0.250)
mesh_convert("5235043213", 0.125)
mesh_convert(64414315, 0.1)
# Not changes
mesh_convert("52350432", 1)
mesh_convert("52350432131", 0.125)
}
