% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_generics.R
\name{moments}
\alias{moments}
\alias{mean}
\alias{median}
\alias{mode}
\alias{var}
\alias{sd}
\alias{skew}
\alias{kurt}
\alias{entro}
\alias{finf}
\title{Moments - Parametric Quantities of Interest}
\usage{
moments(x)

mean(x, ...)

median(x, na.rm = FALSE, ...)

mode(x)

var(x, y = NULL, na.rm = FALSE, use)

sd(x, na.rm = FALSE)

skew(x, ...)

kurt(x, ...)

entro(x, ...)

finf(x, ...)
}
\arguments{
\item{x}{a \code{Distribution} object.}

\item{...}{extra arguments.}

\item{y, use, na.rm}{arguments in \code{mean} and \code{var} standard methods from the
\code{stats} package not used here.}
}
\value{
Numeric, either vector or matrix depending on the moment and the
distribution. The \code{moments()} function returns a list with all the available
methods.
}
\description{
A set of functions that calculate the theoretical moments
(expectation, variance, skewness, excess kurtosis) and other important
parametric functions (median, mode, entropy, Fisher information) of a
distribution.
}
\details{
Given a distribution, these functions calculate the theoretical moments and
other parametric quantities of interest. Some distribution-function
combinations are not available; for example, the \code{sd()} function is
available only for univariate distributions.

The \code{moments()} function automatically finds the available methods for a
given distribution and results all of the results in a list.

Technical Note:
The argument of the moment functions does not follow the naming convention of
the package, i.e. the \code{Distribution} object is names \code{x} rather than \code{distr}.
This is due to the fact that most of the generics are already defined in the
\code{stats} package (\code{mean}, \code{median}, \code{mode}, \code{var}, \code{sd}), therefore the first
argument was already named \code{x} and could not change.
}
\section{Functions}{
\itemize{
\item \code{median()}: Median

\item \code{mode()}: Mode

\item \code{var()}: Variance

\item \code{sd()}: Standard Deviation

\item \code{skew()}: Skewness

\item \code{kurt()}: Kurtosis

\item \code{entro()}: Entropy

\item \code{finf()}: Fisher Information (numeric or matrix)

}}
\examples{
# -----------------------------------------------------
# Beta Distribution Example
# -----------------------------------------------------

# Create the distribution
a <- 3
b <- 5
D <- Beta(a, b)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 0.8, 0.5)) # density function
p(D, c(0.3, 0.8, 0.5)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llbeta(x, a, b)

ebeta(x, type = "mle")
ebeta(x, type = "me")
ebeta(x, type = "same")

mle(D, x)
me(D, x)
same(D, x)
e(D, x, type = "mle")

mle("beta", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vbeta(a, b, type = "mle")
vbeta(a, b, type = "me")
vbeta(a, b, type = "same")

avar_mle(D)
avar_me(D)
avar_same(D)

v(D, type = "mle")
}
\seealso{
\link{distributions}, \link{loglikelihood}, \link{estimation}
}
