% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theoryRowpenUpperBound.R
\name{theoryRowpenUpperBound}
\alias{theoryRowpenUpperBound}
\title{Penalty Parameter for Covariance Estimation Based on Theory}
\usage{
theoryRowpenUpperBound(A, B, n1, n2)
}
\arguments{
\item{A}{column covariance matrix.}

\item{B}{row covariance matrix.}

\item{n1}{sample size of group one.}

\item{n2}{sample size of group two.}
}
\value{
Returns a theoretically guided choice of the
glasso penalty parameter.
}
\description{
This function returns a theoretically-guided choice of
the glasso penalty parameter, based on both the row and
column covariance matrices.
}
\examples{
# Define sample sizes
n1 <- 10
n2 <- 10
n <- n1 + n2
m <- 2e3
# Column covariance matrix (autoregressive of order 1)
A <- outer(1:n, 1:n, function(x, y) 0.2^abs(x - y))
# Row covariance matrix (autoregressive of order 1)
B <- outer(1:n, 1:n, function(x, y) 0.8^abs(x - y))
# Calculate theoretically guided Gemini penalty.
rowpen <- theoryRowpenUpperBound(A, B, n1, n2)
print(rowpen)
}
\references{
Joint mean and covariance estimation with unreplicated matrix-variate data
Michael Hornstein, Roger Fan, Kerby Shedden, Shuheng Zhou
(2018).  Joint mean and covariance estimation with
unreplicated matrix-variate data.  Journal of the American
Statistical Association
}
