% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centerDataTwoGroupsByIndices.R
\name{centerDataTwoGroupsByIndices}
\alias{centerDataTwoGroupsByIndices}
\title{Center Each Column by Subtracting Group Means}
\usage{
centerDataTwoGroupsByIndices(X, group.one.indices, group.two.indices)
}
\arguments{
\item{X}{a data matrix.}

\item{group.one.indices}{indices of observations in group one.}

\item{group.two.indices}{indices of observations in group two.}
}
\value{
Returns a centered data matrix of the same dimensions
as the original data matrix.
}
\description{
This function takes a data matrix and returns a centered
data matrix.  For each column, centering is performed by
subtracting the corresponding group mean from each entry
(i.e. for entries in group one, the group one mean is
subtracted, and for entries in group two, the group two
mean is subtracted).
}
\details{
\bold{Example}
\preformatted{X <- matrix(1:12, nrow=4, ncol=3)
X.cen <- centerDataTwoGroupsByIndices(
  X, group.one.indices=1:2, group.two.indices=3:4)
}
}
