% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeminiB.R
\name{GeminiB}
\alias{GeminiB}
\title{Estimate Row-Row Covariance Structure Using Gemini}
\usage{
GeminiB(X, rowpen, penalize.diagonal = FALSE)
}
\arguments{
\item{X}{Data matrix, of dimensions n by m.}

\item{rowpen}{Glasso penalty parameter.}

\item{penalize.diagonal}{Logical value indicating whether to penalize the
off-diagonal entries of the correlation matrix.  Default is FALSE.}
}
\value{
\item{corr.B.hat}{estimated correlation matrix.}
\item{corr.B.hat.inv}{estimated inverse correlation matrix.}
\item{B.hat}{estimated covariance matrix.}
\item{B.hat.inv}{estimated inverse covariance matrix.}
}
\description{
GeminiB estimates the row-row covariance, inverse covariance,
correlation, and inverse correlation matrices using Gemini.
For identifiability, the covariance factors A and B are scaled so
that A has trace m, where m is the number of columns of X,
A is the column-column covariance matrix, and B is the row-row
covariance matrix.
}
\examples{
n1 <- 5
n2 <- 5
n <- n1 + n2
m <- 20
X <- matrix(rnorm(n * m), nrow=n, ncol=m)
rowpen <- sqrt(log(m) / n)
out <- GeminiB(X, rowpen, penalize.diagonal=FALSE)
# Display the estimated correlation matrix rounded to two
# decimal places.
print(round(out$corr.B.hat, 2))
}
