## -----------------------------------------------------------------------------
# Install package
# devtools::install_github("cathyzzzhang/jointCompRisk")
library(jointCompRisk)

## -----------------------------------------------------------------------------
#Sample datasets included with package
main_df <- read.csv("main_df.csv")
long_df <- read.csv("long_df.csv")

#View data structure
head(main_df)
head(long_df)

#Access help documentation
?main_df
?long_df

## -----------------------------------------------------------------------------
mydata_std <- prep_data_cif(
  data             = main_df,
  ID               = "ID",                             #change this
  TimeToRecovery   = "TimeToRecovery",                   #change this
  TimeToDeath      = "TimeToDeath",                      #change this
  Recov_Censoring  = "RecoveryCensoringIndicator",       #change this
  Death_Censoring  = "DeathCensoringIndicator",          #change this
  Treatment        = "Treatment"                         #change this
)

## -----------------------------------------------------------------------------
res_std <- do_cif_analysis(mydata_std, tau=15)

# Access RMLT1 results (recovery/discharge)
res_std$RMLT1$groups     # Group estimates
res_std$RMLT1$contrast   # Treatment difference

# Access RMLT2 results (death)
res_std$RMLT2$groups     # Group estimates  
res_std$RMLT2$contrast   # Treatment difference

## -----------------------------------------------------------------------------
prepped_w <- prep_data_weighted_cif2(
  data_main = main_df,
  data_long = long_df,

  wID_main              = "ID",
  wTimeToRecovery_main  = "TimeToRecovery",
  wTimeToDeath_main     = "TimeToDeath",
  wRecov_Censoring_main = "RecoveryCensoringIndicator",
  wDeath_Censoring_main = "DeathCensoringIndicator",
  wTreatment_main       = "Treatment",
  wBaselineScore_main   = "BaselineScore",
  
  wID_long              = "PersonID",
  wADY_long             = "RelativeDay",
  wScore_long           = "OrdinalScore",

  wStates_death         = c(4,5,6,7,8), 
  wWeights_death        = c(2,1.5,1,0.5,0.2),
  wStates_discharge     = c(4,5,6,7,8),
  wWeights_discharge    = c(0.2,0.5,1,1.5,2)
)

## -----------------------------------------------------------------------------
#Analysis at 15 days
res_w15 <- do_weighted_cif_analysis(prepped_w, tau=15)

# Display WRMLT1 results (discharge-focused analysis)  
#Group estimates with standard errors
res_w15$WRMLT1$groups
#Treatment difference: Treatment1 - Treatment0
res_w15$WRMLT1$contrast

# Display WRMLT2 results (discharge-focused analysis)  
res_w15$WRMLT2$groups
res_w15$WRMLT2$contrast

