% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.jcp.r
\name{plot.jcp}
\alias{plot.jcp}
\title{plot.jcp}
\usage{
\method{plot}{jcp}(x, cex = 1, cex.main = 1, ...)
}
\arguments{
\item{x}{object of class jcp}

\item{cex}{numeric, global sizes in plot}

\item{cex.main}{numeric, size of titles}

\item{...}{additional arguments}
}
\value{
No return value, called for side effects
}
\description{
Plot method for class 'jcp'
}
\examples{
# Normal distributed sequence with 3 change points at
# c1=250 (change in expectation), 
# c2=500 (change in variance) and 
# c3=750 (change in expectation and variance) 
set.seed(0)
m      <- c(8,10,10,3);   s  <- c(4,4,10,5)
x      <- rnorm(1000, mean=rep(m,each=250), sd=rep(s,each=250))
result <- jcp(x)
summary(result)
plot(result)

# Set additional parameters (window set)
result2 <- jcp(x,H=c(80,160,240))
summary(result2)
plot(result2)

}
\references{
Michael Messer (2021) Bivariate change point detection - joint detection of changes in expectation and variance, Scandinavian Journal of Statistics, DOI 10.1111/sjos.12547.
}
\seealso{
\code{\link{jcp}, \link{summary.jcp}}
}
\author{
Michael Messer
}
