% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jcp.r
\name{jcp}
\alias{jcp}
\title{jcp}
\usage{
jcp(x, H = NA, q = NA, alpha = 0.05, sim = 1000, region = "square")
}
\arguments{
\item{x}{numeric vector. Input sequence of random variables.}

\item{H}{NA or numeric vector. Window set. If NA (default), then H is automatically set. If not NA, then H must an increasing vector of positive integers with maximum =< length(x)/2.}

\item{q}{NA or numeric value. Rejection threshold. If NA (default), then the rejection boundary is derived in simulations (from Gaussian process limit) according to sim and alpha. If not NA, then q is considered predefined and must be set a postive real number.}

\item{alpha}{numeric value. Significance level. Must be in (0,1), default = 0.05. In case of predefined q, alpha is set to NA.}

\item{sim}{numeric value. Number of simulations of limit process for approximation of q. Must be positive integer, default = 1000. In case of predefined q, sim is set to NA.}

\item{region}{character string. Defines rejection region, default = "square". Must be chosen either "square", "circle" or "ellipse".}
}
\value{
invisible list
\item{changepoints}{detected change points (increasingly ordered)}
\item{mean_sd}{matrix of estimated means and standard deviations}
\item{M}{test statistic}
\item{q}{rejection threshold}
\item{H}{window set}
\item{sim}{number of simulations of the limit process (approximation of q)}
\item{alpha}{significance level}
\item{region}{rejection region}
\item{method}{derivation of threshold q, either asymptotic or predefined}
\item{x}{input sequence}
\item{EVrho}{list containing the auxiliary processes E, V and correlation rho, for each element of H one list entry}
\item{CP_meta}{matrix containing meta information of estimation. Estimated change points (increasingly ordered), responsible window h, components E, V and rho of joint statistic at estimated change points (regarding responsible window)}
\item{SFA}{detected change points of single filter algorithms}
}
\description{
Joint change point detection - expectation and variance - via bivariate moving sum statistics
}
\examples{
# Normal distributed sequence with 3 change points at
# c1=250 (change in expectation), 
# c2=500 (change in variance) and 
# c3=750 (change in expectation and variance) 
set.seed(0)
m      <- c(8,10,10,3);   s  <- c(4,4,10,5)
x      <- rnorm(1000, mean=rep(m,each=250), sd=rep(s,each=250))
result <- jcp(x)
summary(result)
plot(result)

# Set additional parameters (window set)
result2 <- jcp(x,H=c(80,160,240))
summary(result2)
plot(result2)


}
\references{
Michael Messer (2021) Bivariate change point detection - joint detection of changes in expectation and variance, Scandinavian Journal of Statistics, DOI 10.1111/sjos.12547.
}
\seealso{
\code{\link{plot.jcp}, \link{summary.jcp}}
}
\author{
Michael Messer
}
