% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_cwt.R
\name{calculate_cwt}
\alias{calculate_cwt}
\title{calculate_cwt}
\usage{
calculate_cwt(Z, TF, directionflow, G, thr = 6, Gth = 30)
}
\arguments{
\item{Z}{Data frame with the total shear vorticity and dates.}

\item{TF}{Data frame with resultant flow and dates.}

\item{directionflow}{Data frame with the direction of the flow and dates.}

\item{G}{Data frame with Gale days and dates.}

\item{thr}{Numeric threshold used for Unclassified days.}

\item{Gth}{Numeric threshold used for Gale days.}
}
\value{
A list with two objects:
\itemize{
\item Total_CWT with five groups of weather types: LWT_D, LWT_C, LWT_CH, LWT_U and LWT_G
      The main four groups contain the total of 27 weather types and the five list LWT_G refers to the gale days.
      \itemize{
      \item LWT_D:  8 directional types.
      \item LWT_C:  1 anticyclonic and  1 cyclonic.
      \item LWT_CH: 16 hybrid types.
      \item LWT_U: 1 unclassified type.
      }
\item Logical values of daily occurrence of each type.
     The user might want to use these values to get composites with specific atmospheric fields (e.g. pressure, temperature).
}
}
\description{
Applies the rules to obtain the weather types.
             (more details, see Jones et al. 1997)
}
\details{
As defined in the original scheme, the threshold to determine unclassified days is 6.
         Gale days are estimated by using a threshold of 30. If Gale days with a greater
         intensity (e.g. 40 or 50) is wanted, Gth must be changed.
         The airflow indices are used within the following rules
         to define the appropriate Lamb weather types.
\itemize{
\item  The appropriate direction is calculated on an eight-point compass allowing 45° per sector.
\item  If abs(Z) is less than TF, flow is essentially pure directional type.
\item  If |Z| is greater than 2TF, then the pattern is strongly cyclonic (Z > 0) or anticyclonic (Z < 0).
\item  If |Z| lies between TF and 2TF then the flow is partly (anti-) cyclonic and this corresponds to one
       of Lamb’s synoptic/direction hybrid types, e.g. AE.
\item  If TF is less than 6 and |Z| is less than 6, there is light indeterminate flow corresponding to Lamb’s
       unclassified type U.
       }
}
\seealso{
\code{\link{classification_jc}}
}
