% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hedgehog.survival.df}
\alias{hedgehog.survival.df}
\title{Hedgehog survival}
\format{A data.frame with 31 observations and 2 columns:
\describe{
\item{BI}{The Bunnell Index (BI) of the hedgehog at the time of admission.}
\item{survived}{A logical variable recording whether the hedgehog survived or died.}
}}
\source{
Bunnell, T. (2002) The Assessment of British Hedgehog (Erinaceus europaeus)
Casualties on Arrival and Determination of Optimum Release Weights Using a New
IndexJournal of Wildlife Rehabilitation 25 (4):11-21
}
\usage{
hedgehog.survival.df
}
\description{
The Bunnell Index (or BI) is a measurement of how tightly the hedgehog are
curled into a ball. One measurement is taken round the middle of the animal
to cross at the point where the nose ends ("A," latitudinal circumference).
The other measurement, using a second tape measure already secured underneath
the animal, is taken round the hedgehog from head to tail ("B," longitudinal
circumference). Care must be taken with both measurements to ensure that the
ends of the tape measure meet easily without altering the shape/positioning
of the hedgehog. When obtaining measurement A, the positioning of the tape
measure is crucial; a measurement taken lower down toward the tail can result
in a lower (inaccurate) reading. Repeatedly measuring many hedgehogs over
several consecutive days demonstrated consistent BI values and hence the
reliability of the method. A is divided by B to give a value for the BI. It
is important to determine the BI value to two decimal places (i.e., a value
of 0.794, becomes 0.79, while a value of 0.805 becomes 0.81).
}
\keyword{datasets}
