% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_jack_ks.R
\name{hist_jack_ks}
\alias{hist_jack_ks}
\title{Histogram with Jackstrap Efficiency Indicators:  This function builds graphics with distributions of efficiency indicators
without outliers and complete sample. The outliers are defined by K-S Test.}
\usage{
hist_jack_ks(efficiency, model_hist_ks)
}
\arguments{
\item{efficiency}{is the jackstrap object created by jackstrap function.}

\item{model_hist_ks}{is the desired graphic model. There are four kinds: 1- Density Histogram of efficiency indicator with
complete sample and without outliers by K-S test; 2 - Histogram of efficiency with complete sample and without outliers by K-S test;
3 - Histogram of efficiency without ouliers by K-S test; 4 - Histogram of efficiency with complete sample.}
}
\value{
Return the plot with efficiency indicators with complete sample and/or without outliers by combination leverage level and K-S test;
}
\description{
Histogram with Jackstrap Efficiency Indicators:  This function builds graphics with distributions of efficiency indicators
without outliers and complete sample. The outliers are defined by K-S Test.
}
\examples{
 \dontshow{
   library(jackstrap)
   test_data <- data.frame(mun=c(1:10), cod=c(1:10), y=c(5,7,6,7,4,6,8,9,3,1),
                          x=c(7,8,10,22,15,7,22,17,10,5))
   effic_test <- jackstrap (data=test_data, ycolumn=1, xcolumn=1, bootstrap=1,
                  perc_sample_bubble=1, dea_method="crs", orientation_dea="in",
                 n_seed = 2000, repos=FALSE, num_cores=1)
   effic_ks <- jackstrap_ks (data=test_data, jackstrap_obj=effic_test,
                            num_cores = 1)
   plot_ks <- hist_jack_ks(effic_ks, 1)
 }
 \donttest{
    #Build charts with efficiency indicators with jackstrap method and K-S test criterion
    hist_jack_ks(efficiency_ks, 1)
    hist_jack_ks(efficiency_ks, 2)
    hist_jack_ks(efficiency_ks, 3)
    hist_jack_ks(efficiency_ks, 4)
 }
}
