% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.R
\name{set_git_timeout}
\alias{set_git_timeout}
\title{Extend git credential cache time-out}
\usage{
set_git_timeout(timeout = 14400, global = FALSE)
}
\arguments{
\item{timeout}{number of seconds before timeout}

\item{global}{whether the change should be global or local to the repo}
}
\value{
No return value, called for side effects
}
\description{
Set the number of seconds before the git credential cache times
out. Note that this is written for work on remote servers where we do not
want to store our git credentials because other might have access to it, or
impersonate us. On a trusted machine the most common setting would be (on
a linux machine) git credential.helper store. However, some caching is
required when working on a remote server because frequent commit-push
cycles where you have to write out your username and password every time is
not nice.

By default this will only apply to the repo you are working in. If you call
the global version take care that this is what you want. Also by default
the timeout is set to 4 hours (14400 seconds).
}
