% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector.R
\name{vector-detect-pairwise}
\alias{vector-detect-pairwise}
\alias{iv_pairwise_between}
\alias{iv_pairwise_includes}
\title{Pairwise detect relationships between a vector and an iv}
\usage{
iv_pairwise_between(x, y)

iv_pairwise_includes(x, y)
}
\arguments{
\item{x, y}{\verb{[vector, iv]}

For \code{iv_pairwise_between()}, \code{x} must be a vector and \code{y} must be an iv.

For \code{iv_pairwise_includes()}, \code{x} must be an iv and \code{y} must be a vector.

\code{x} and \code{y} will be recycled against each other.}
}
\value{
A logical vector the same size as the common size of \code{x} and \code{y}.
}
\description{
This family of functions detects different types of relationships between a
vector and an iv \emph{pairwise}. where pairwise means that the i-th value of \code{x}
is compared against the i-th value of \code{y}. This is in contrast to
\code{\link[=iv_between]{iv_between()}}, which works more like \link[base:match]{base::\%in\%}.
\itemize{
\item \code{iv_pairwise_between()} detects if the i-th value of \code{x}, a vector, falls
between the bounds of the i-th value of \code{y}, an iv.
\item \code{iv_pairwise_includes()} detects if the i-th value of \code{x}, an iv, includes
the i-th value of \code{y}, a vector.
}

These functions return a logical vector the same size as the common size of
\code{x} and \code{y}.
}
\examples{
x <- as.Date(c("2019-01-01", "2019-01-08", "2019-01-21"))

y <- iv_pairs(
  as.Date(c("2019-01-01", "2019-01-03")),
  as.Date(c("2019-01-07", "2019-01-09")),
  as.Date(c("2019-01-18", "2019-01-21"))
)

x
y

# Does the i-th value of `x` fall between the i-th interval of `y`?
iv_pairwise_between(x, y)

# Does the i-th interval of `y` include the i-th value of `x`?
iv_pairwise_includes(y, x)

a <- c(1, NA, NA)
b <- iv_pairs(c(NA, NA), c(3, 4), c(NA, NA))

# Missing intervals always propagate
iv_pairwise_between(a, b)
iv_pairwise_includes(b, a)
}
\seealso{
\link[=relation-locate]{Locating relationships}

\link[=vector-locate]{Locating relationships between a vector and an iv}

\link[=vector-detect]{Detecting relationships between a vector and an iv}
}
