% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SamplingUncertainty.R
\name{draw_bounds}
\alias{draw_bounds}
\title{Computes bounds for simulated data}
\usage{
draw_bounds(
  y_name,
  T_name,
  z_name,
  data,
  controls = NULL,
  r_TstarU_restriction = NULL,
  k_restriction = NULL,
  n_draws = 5000
)
}
\arguments{
\item{y_name}{Character vector of the name of the dependent variable}

\item{T_name}{Character vector of the names of the preferred regressors}

\item{z_name}{Character vector of the names of the instrumental variables}

\item{data}{Data to be analyzed}

\item{controls}{Character vector containing the names of the exogenous regressors}

\item{r_TstarU_restriction}{2 element vector of bounds on r_TstarU}

\item{k_restriction}{2-element vector of bounds on kappa}

\item{n_draws}{Integer number of simulations to draw}
}
\value{
List containing simulated data observables (covariances,
  correlations, and R-squares), indications of whether the identified set
  is empty, the unrestricted and restricted bounds on instrumental relevance,
  instrumental validity, and measurement error.
}
\description{
This function takes data and user restrictions on measurement error and
  endogeneity and simulates data and the resulting bounds on instrument
  validity.
}
