% Generated by roxygen2 (4.0.1): do not edit by hand
\name{quantify}
\alias{quantify}
\title{Count the number of times an iterable object is TRUE}
\usage{
quantify(object)
}
\arguments{
\item{object}{an iterable object}
}
\value{
the number of \code{TRUE} elements
}
\description{
Returns the number of elements from an iterable object evaluate to
\code{TRUE}.
}
\examples{
it <- iterators::iter(c(TRUE, FALSE, TRUE))
quantify(it) # 2

set.seed(42)
x <- sample(c(TRUE, FALSE), size=10, replace=TRUE)
quantify(x) # Equivalent to sum(x)
}

