% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icycle}
\alias{icycle}
\title{Iterator that cycles indefinitely through an iterable object}
\usage{
icycle(object, times = NULL)
}
\arguments{
\item{object}{object to cycle indefinitely.}

\item{times}{the number of times \code{object} is returned. If \code{NULL}
(default), \code{object} is returned indefinitely.}
}
\value{
iterator that returns \code{object} in sequence
}
\description{
Constructs an iterator that returns an iterable object in sequence over and
over again.
}
\details{
Runs indefinitely unless the \code{times} argument is specified.
}
\examples{
it <- icycle(1:3)
iterators::nextElem(it) # 1
iterators::nextElem(it) # 2
iterators::nextElem(it) # 3
iterators::nextElem(it) # 1
iterators::nextElem(it) # 2
iterators::nextElem(it) # 3
iterators::nextElem(it) # 1

it2 <- icycle(1:3, times=2)
as.list(it2)

# Can return the results from a function.
it3 <- icycle(function() rnorm(1))
iterators::nextElem(it)
iterators::nextElem(it)
iterators::nextElem(it)
iterators::nextElem(it)
}

