% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{take}
\alias{take}
\alias{take.default}
\alias{take.iteror}
\title{Return the first n elements of an iterable object in a vector.}
\usage{
take(obj, n = 1, mode = "list", ...)

\method{take}{default}(obj, n = 1, mode = "list", ...)

\method{take}{iteror}(obj, n = 1, mode = "list", ...)
}
\arguments{
\item{obj}{An iterable object.}

\item{n}{The maximum number of elements to extract from the iteror.}

\item{mode}{The mode of vector to return.}

\item{...}{Further arguments may be passed along to the \link{iteror} constructor.}
}
\value{
a list of the first \code{n} items of the iterable
\code{obj}
}
\description{
Returns the first \code{n} elements of an iterable \code{object} as a list.
If \code{n} is larger than the number of elements in \code{object}, the
entire iterator is consumed.
}
\details{
A function \code{take} first appeared in package \code{itertools2}.
It is basically an alias for \link{as.list} but defaults to n=1.
}
\examples{
take(1:10, 3) # 1 2 3
take(icount(), 10) # 1:10
take(icount(5), 10) # 1 2 3 4 5
}
\seealso{
concat as.vector.iteror

as.vector.iteror
}
