% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/izip.R
\name{i_zip}
\alias{i_zip}
\alias{i_zip_longest}
\title{Combine several iterables in parallel.}
\usage{
i_zip(...)

i_zip_longest(..., fill = NA)
}
\arguments{
\item{...}{multiple arguments to iterate through in parallel}

\item{fill}{the value used to replace missing values when the iterables in
\code{...} are of uneven length}
}
\value{
iterator that iterates through each argument in sequence
}
\description{
The resulting iterator aggregates one element from each of the
iterables into a list for each iteration. Used for lock-step
iteration over several iterables at a time.
}
\details{
For \verb{[i_zip]}, the output will finish when any of the underlying iterables finish.

Originally from the \code{itertools} package.

Originally from package \code{itertools2}.
}
\examples{

# Iterate over two iterables of different sizes
as.list(i_zip(a=1:2, b=letters[1:3]))

it <- i_zip_longest(x=1:3, y=4:6, z=7:9)
nextOr(it, NA) # list(x=1, y=4, z=7)
nextOr(it, NA) # list(x=2, y=5, z=8)
nextOr(it, NA) # list(x=3, y=6, z=9)

it2 <- i_zip_longest(1:3, 4:8)
nextOr(it2, NA) # list(1, 4)
nextOr(it2, NA) # list(2, 5)
nextOr(it2, NA) # list(3, 6)
nextOr(it2, NA) # list(NA, 7)
nextOr(it2, NA) # list(NA, 8)

it3 <- i_zip_longest(1:2, 4:7, levels(iris$Species), fill="w00t")
nextOr(it3, NA) # list(1, 4, "setosa")
nextOr(it3, NA) # list(2, 5, "versicolor")
nextOr(it3, NA) # list("w00t", 6, "virginica")
nextOr(it3, NA) # list("w00t", 7, "w00t")
}
