% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{calcularFrecuenciaAlternativas}
\alias{calcularFrecuenciaAlternativas}
\title{Frecuencia de alternativas}
\usage{
calcularFrecuenciaAlternativas(
  respuestas,
  alternativas,
  clave = NULL,
  frecuencia = FALSE,
  digitos = 2
)
}
\arguments{
\item{respuestas}{Un data frame con las respuestas corregidas
de los estudiantes.}

\item{alternativas}{Un vector con las alternativas posibles como respuestas.}

\item{clave}{Un data frame con las respuestas correctas a cada pregunta.}

\item{frecuencia}{Un valor lógico que determina si la información
se presenta como frecuencia (\code{TRUE}) o proporción (\code{FALSE}).
Por defecto es \code{FALSE}}

\item{digitos}{La cantidad de dígitos significativos que tendrá el resultado.}
}
\value{
Un data frame con los ítems como filas y las frecuencias de las
alternativas como columnas. Si está presente la clave como parámetro, se
agrega la alternativa correcta como columna.
}
\description{
Calcula la frecuencia o proporcion de las alternativas seleccionadas en
cada ítem.
}
\examples{
alternativas <- c("A", "B", "C", "D", "E", "*")
respuestas <- datos[,-1]
calcularFrecuenciaAlternativas(respuestas, alternativas, clave, frecuencia=TRUE)

}
\seealso{
\code{\link{corregirRespuestas}}, \code{\link{datos}} y
\code{\link{clave}}.
}
