% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{qscore}
\alias{qscore}
\title{Quantile scores for IDR or raw forecasts}
\usage{
qscore(predictions, quantiles, y)
}
\arguments{
\item{predictions}{either an object of class \code{idr} (output of
\code{\link{predict.idrfit}}), or a \code{data.frame} of numeric variables. In
the latter case, quantiles are computed using the empirical distribution of
the variables in \code{predictions}.}

\item{quantiles}{numeric vector of desired quantiles.}

\item{y}{a numeric vector of obervations of the same length as the number of
predictions, or of length 1. In the latter case, \code{y} will be used
for all predictions.}
}
\value{
A matrix of the quantile scores for the desired quantiles, one column per
quantile.
}
\description{
Computes quantile scores of IDR quantile predictions or of quantile
predictions from raw forecasts in a \code{data.frame}.
}
\details{
The quantile score of a forecast \emph{x} for the \emph{u}-quantile is
defined as
\deqn{
2(1{x > y} - u)(x - y),
}
where \emph{y} is the observation. For \emph{u = 1/2}, this equals the mean
absolute error of the median forecast.
}
\examples{
data("rain")

## Postprocess HRES forecast using data of 3 years

X <- rain[1:(3 * 365), "HRES", drop = FALSE]
y <- rain[1:(3 * 365), "obs"]

fit <- idr(y = y, X = X)

## Compute mean absolute error of the median postprocessed forecast using
## data of the next 2 years (out-of-sample predictions) and compare to raw
## HRES forecast

data <- rain[(3 * 365 + 1):(5 * 365), "HRES", drop = FALSE]
obs <- rain[(3 * 365 + 1):(5 * 365), "obs"]

predictions <- predict(fit, data = data)
idrMAE <- mean(qscore(predictions, 0.5, obs))
rawMAE <- mean(qscore(data, 0.5, obs))

c("idr" = idrMAE, "raw" = rawMAE)
}
\references{
Gneiting, T. and Raftery, A. E. (2007), 'Strictly proper scoring rules,
prediction, and estimation', Journal of the American Statistical Association
102(477), 359-378
}
\seealso{
\code{\link{predict.idrfit}}, \code{\link{qpred}}
}
