% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{qpred}
\alias{qpred}
\alias{qpred.idr}
\alias{qpred.data.frame}
\title{Quantile function of IDR or raw forecasts}
\usage{
qpred(predictions, quantiles)

\method{qpred}{idr}(predictions, quantiles)

\method{qpred}{data.frame}(predictions, quantiles)
}
\arguments{
\item{predictions}{either an object of class \code{idr} (output of
\code{\link{predict.idrfit}}), or a \code{data.frame} of numeric variables. In
the latter case, quantiles are computed using the empirical distribution of
the variables in \code{predictions}.}

\item{quantiles}{numeric vector of desired quantiles.}
}
\value{
A matrix of forecasts for the desired quantiles, one column per quantile.
}
\description{
Evaluate the the quantile function of IDR predictions or of unprocessed
forecasts in a \code{data.frame}.
}
\details{
The quantiles are defined as lower quantiles, that is,
\deqn{
  q(u) = inf(x: cdf(x) >= u).
}
}
\examples{
data("rain")

## Postprocess HRES forecast using data of 3 years

X <- rain[1:(3 * 365), "HRES", drop = FALSE]
y <- rain[1:(3 * 365), "obs"]

fit <- idr(y = y, X = X)

## Compute 95\%-quantile forecast given that the HRES forecast is
## 2.5 mm, 5 mm or 10 mm

predictions <- predict(fit, data = data.frame(HRES = c(2.5, 5, 10)))
qpred(predictions, quantiles = 0.95)
}
\seealso{
\code{\link{predict.idrfit}}, \code{\link{cdf}}, \code{\link{qscore}}
}
