[![CRAN Version](https://www.r-pkg.org/badges/version/isingLenzMC)](https://cran.r-project.org/package=isingLenzMC)
[![Total RStudio Cloud Downloads](https://cranlogs.r-pkg.org/badges/grand-total/isingLenzMC?color=brightgreen)](https://cran.r-project.org/package=isingLenzMC)
[![RStudio Cloud Downloads](https://cranlogs.r-pkg.org/badges/isingLenzMC?color=brightgreen)](https://cran.r-project.org/package=isingLenzMC)
[![arXiv:1606.08693](http://img.shields.io/badge/arXiv-1606.08693-B31B1B.svg)](https://arxiv.org/abs/1606.08693)
[![arXiv:1405.4497](http://img.shields.io/badge/arXiv-1405.4497-B31B1B.svg)](https://arxiv.org/abs/1405.4497)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1065942.svg)](https://doi.org/10.5281/zenodo.1065942)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.17151290.svg)](https://doi.org/10.5281/zenodo.17151290)


# isingLenzMC: Monte Carlo for Classical Ising Model

* [Stable release on CRAN](https://CRAN.R-project.org/package=isingLenzMC)   
* [Development repository](https://github.com/msuzen/isingLenzMC)

## Description

Classical Ising Model is a land mark system in statistical physics. The model explains 
the physics of spin glasses and magnetic materials, and cooperative phenomenon 
in general, for example phase transitions and neural networks. This package provides 
utilities to simulate one dimensional Ising Model with Metropolis and Glauber Monte 
Carlo with single flip dynamics in periodic boundary conditions. Utility functions 
for exact solutions are provided. Such as transfer matrix for 1D. Example use cases 
are as follows: Measuring effective ergodicity and power-laws in so called 
functional-diffusion. 

## Example use cases

These examples are scientific use cases of the package, some corresponds to papers.

*  [Measuring effective ergodicity on differring temperature ranges](inst/examples/effectiveErgodicity/README.md) 
* [Ergodic Dynamics of Ising Model : functional-diffusion regimes](inst/examples/powerLawErgodicity)

## Related Publications and Datasets

* Effective ergodicity in single-spin-flip dynamics  
 Mehmet Suezen, [Phys. Rev. E 90, 032141](https://doi.org/10.1103/PhysRevE.90.032141)  
 [Dataset](https://doi.org/10.5281/zenodo.1065942)
* Anomalous diffusion in convergence to effective ergodicity,
Suezen, Mehmet, [arXiv:1606.08693](https://arxiv.org/abs/1606.08693)  
[Dataset](https://doi.org/10.5281/zenodo.17151290) 

