% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretree.R
\name{LtoL_multi.tree}
\alias{LtoL_multi.tree}
\title{Long-to-long, multiple trees}
\usage{
LtoL_multi.tree(
  data,
  cmx_list,
  item_list,
  id.col,
  item.col,
  resp.col,
  covar.col = NULL,
  time.col = NULL
)
}
\arguments{
\item{data}{a long-format (person-item-response) data set}

\item{cmx_list}{a list including all tree structures}

\item{item_list}{a list of vectors, with a length matching the length of \code{cmx_list}; 
each element of such a vector points to an item ID in \code{item.col} using the corresponding
mapping matrix}

\item{id.col}{the person ID column}

\item{item.col}{the item ID column}

\item{resp.col}{the response column}

\item{covar.col}{columns containing covariates}

\item{time.col}{the time column. If not NULL, \code{time.col} 
should be nested in \code{id.col}, since it indicates repeated measures within persons}
}
\description{
Recode a long format data frame to a long format IRTRees data frame
in the case when items may have different tree structures
}
\details{
Many examples of mapping matrices are given in the vignette. Columns may be specified 
by numeric index or by name. Response categories must be coded with consecutive integers 
starting from 1, not 0. Missing data should be properly represented as NA.
}
