% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_resp.R
\name{sim_resp}
\alias{sim_resp}
\alias{sim_resp,Item-method}
\alias{sim_resp,Testlet-method}
\alias{sim_resp,Itempool-method}
\alias{sim_resp,numMatDfListChar-method}
\title{Generate responses for a given model}
\usage{
sim_resp(ip, theta, prop_missing = 0, output = "matrix")

\S4method{sim_resp}{Item}(ip, theta, prop_missing = 0, output = "matrix")

\S4method{sim_resp}{Testlet}(ip, theta, prop_missing = 0, output = "matrix")

\S4method{sim_resp}{Itempool}(ip, theta, prop_missing = 0, output = "matrix")

\S4method{sim_resp}{numMatDfListChar}(ip, theta, prop_missing = 0, output = "matrix")
}
\arguments{
\item{ip}{An \code{\link{Item-class}}, \code{\link{Itempool-class}},
\code{\link{Testlet-class}} object containing the item parameters.}

\item{theta}{An object containing the subject ability parameters.}

\item{prop_missing}{Proportion of responses that should be missing. Default
value is \code{0}. This argument is valid for only
\code{\link{Itempool-class}} and \code{\link{Testlet-class}} objects.}

\item{output}{Type of the output. Following options are available:
\describe{
  \item{\code{"matrix"}}{A \code{matrix} object.}
  \item{\code{"response_set"}}{A \code{\link{Response_set-class}}
        object with item pool attached.}
}}
}
\value{
A vector of responses.
}
\description{
\code{sim_resp} Generate dichotomous (0 or 1) or polytomous responses for
given ability and item parameter.
}
\examples{
## Simulate Responses for an Item object ##
item <- generate_item(model = "3PL")
sim_resp(ip = item, theta = rnorm(1))

item <- generate_item(model = "GPCM")
sim_resp(ip = item, theta = rnorm(1))


item <- generate_item(model = "GRM")
sim_resp(ip = item, theta = rnorm(1))

## Simulate Responses for a Testlet object ##
# Create a testlet
testlet <- testlet(c(item(b = 1), item(a = .8, b = 3.1),
                   item(b = -1:1, model = "PCM")))
sim_resp(ip = testlet, theta = rnorm(1))
## Simulate Responses for an Itempool object ##
# Create 3PL IRT item parameters
ip <- itempool(a = rlnorm(10, 0, 0.3), b = rnorm(10), c = runif(10, 0, .3))
# Simulate responses for one theta:
sim_resp(ip = ip, theta = rnorm(1))
# Simulate responses for eight thetas:
sim_resp(ip = ip, theta = rnorm(8))

# Create Graded Response Model Parameters
ip <- generate_ip(n = 5, model = "GRM", n_categories = c(3, 4, 8, 5, 4))
# Simulate responses for one theta:
sim_resp(ip = ip, theta = rnorm(1))
# Simulate responses for 5 thetas:
sim_resp(ip = ip, theta = rnorm(5))
# Set 10\% of the item responses as missing
sim_resp(ip = ip, theta = rnorm(5), prop_missing = .1)
}
\author{
Emre Gonulates
}
