% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.R
\name{mean,Itempool-method}
\alias{mean,Itempool-method}
\title{Calculate the expected value of an Itempool}
\usage{
\S4method{mean}{Itempool}(x, ...)
}
\arguments{
\item{x}{An \code{\link{Itempool-class}} object containing the item
parameters.}

\item{...}{Additional parameters. Specifically \code{theta} argument is
required. \code{theta} should be a numeric vector of ability parameters.}
}
\value{
Item expected values at given theta values will be returned.
}
\description{
\code{mean} Returns the expected values of each item in an
  \code{\link{Itempool-class}} object for a given ability or abilities,
  i.e. \eqn{\theta}.
}
\examples{
ip <- generate_ip(model = "2PL")
mean(ip, theta = 1.2)
mean(ip, 1.2)

ip <- generate_ip(model = "GPCM")
mean(ip, theta = -0.37)
mean(ip, -1.55)
}
\author{
Emre Gonulates
}
