% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_analysis.R
\name{item_analysis}
\alias{item_analysis}
\title{Item Analysis Function}
\usage{
item_analysis(
  resp,
  criterion = NULL,
  ip = NULL,
  stats = c("n", "pval", "pbis", "bis", "pbis_adj", "bis_adj"),
  suppress_output = FALSE
)
}
\arguments{
\item{resp}{A \code{\link{Response_set-class}} object, \code{matrix} or
\code{data.frame} containing the item responses.}

\item{criterion}{Provide a continuous criterion variable such as a total
raw score, or theta score that will be used in the calculation of
correlation calculations. If this value is \code{NULL}, the total score
will be used.}

\item{ip}{An \code{\link{Itempool-class}} object. This will help function
in two ways. First, if the \code{resp} is
a \code{\link{Response_set-class}} object, the function will help the
responses to be arranged in the same order as \code{ip}. Second, if there
are polytomous items in the data, \code{ip} will help finding the maximum
values of each item. Otherwise, the maximum values each item can take
will be calculated using data, which may be fallible.}

\item{stats}{A vector of string containing the columns/statistics to be
calculated. \code{'item_id'} column will be added by default. Some or all
of the following columns can be added to the output:
\code{c("n", "pval", "pbis", "bis", "pbis_adj", "bis_adj")}.
Please see the 'value' section below to see the details of these columns.
By default, all of the columns above will be calculated.}

\item{suppress_output}{If \code{TRUE}, the function will suppress
console output. Default value is \code{FALSE}}
}
\value{
A data.frame with following columns:
  \describe{
    \item{'item_id'}{Item ID.}
    \item{'n'}{Number of examinees responded this item.}
    \item{'pval'}{p-value, proportion of examinees correctly answered items.
      If there are polytomous items in the data, p-value will be calculated
      by dividing the mean of the scores for the item by the maximum
      possible score of the item.}
    \item{'pval_unadj'}{Unadjusted p-value, this is the mean of item scores
      that is not adjusted for the maximum possible score as \code{'pval'}
      column does. For dichotomous items, this will be the same as
      \code{'pval'} column.}
    \item{'pbis'}{Point biserial correlation.}
    \item{'bis'}{Biserial correlation.}
    \item{'pbis_adj'}{Point biserial correlation between item and total score
      without this item. Note that this stat is only available when
      criterion is \code{NULL}.}
    \item{'bis_adj'}{Biserial correlation between item and total score
      without this item. Note that this stat is only available when
      criterion is \code{NULL}.}
  }
}
\description{
Item Analysis Function
}
\examples{
theta <- rnorm(100)
ip <- generate_ip(n = 20)
resp <- sim_resp(ip = ip, theta = theta, prop_missing = .2)
# Item analysis based on total scores
item_analysis(resp)
# Item analysis based on theta scores
item_analysis(resp, criterion = theta)

}
\author{
Emre Gonulates
}
