% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc1factor.r
\name{pvals.ICC1a}
\alias{pvals.ICC1a}
\title{P-value of the ICC under ANOVA Model 1A for arbitrary null values.}
\usage{
pvals.ICC1a(ratings, rho.zero = 0)
}
\arguments{
\item{ratings}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (there could be duplicates
if a subject was assigned multiple ratings) and each of the remaining columns is associated with a particular rater and contains its
numeric ratings.}

\item{rho.zero}{This is an optional parameter that represents a vector containing an arbitrary number of null values between 0 and 1
for which a p-value will be calculated. If not specified then its defauklt value will be 0.}
}
\value{
This function returns a vector containing p-values associated with the null values specified in the parameter rho.zero.
}
\description{
This function computes the p-value associated with the Intraclass Correlation Coefficient (ICC) under the one-factor ANOVA model
where each subject may be rated by a different group of raters.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
pvals.ICC1a(iccdata1,c(0,0.17,0.22,0.35))
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} chapter 8, section 8.3.2, equation
8.3.4. Advanced Analytics, LLC.
}
