% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simJJLY.R
\name{simJJLY}
\alias{simJJLY}
\title{IFS similarity measure simJJLY}
\usage{
simJJLY(ma, na, mb, nb, ha, hb, k)
}
\arguments{
\item{ma}{IFS membership values for the data set x computed using either triangular or trapezoidal or guassian membership function}

\item{na}{IFS non-membership values for the data set x computed using either Sugeno and Terano's  or Yager's non-membership function}

\item{mb}{IFS membership values for the data set y computed using either triangular or trapezoidal or guassian membership function}

\item{nb}{IFS non-membership values for the data set y computed using either Sugeno and Terano's  or Yager's non-membership function}

\item{ha}{IFS hesitancy values for the data set x}

\item{hb}{IFS hesitancy values for the data set y}

\item{k}{A constant value, considered as 1}
}
\value{
The IFS similarity values of data set y with data set x
}
\description{
IFS similarity measure values using simJJLY computation technique with membership,non-membership, and hesitancy values of two objects or set of objects.
}
\examples{
x<-matrix(c(12,9,14,11,21,16,15,24,20,17,14,11),nrow=4)
y<-matrix(c(11,21,6),nrow=1)
a<-mn(x)
b<-std(x)
a1<-mn(y)
b1<-std(y)
lam<-0.5
ma<-memG(a,b,x)
na<-nonmemS(ma,lam)
ha<-hmemIFS(ma,na)
mb<-memG(a1,b1,y)
nb<-nonmemS(mb,lam)
hb<-hmemIFS(mb,nb)
k<-1
simJJLY(ma,na,mb,nb,ha,hb,k)
#[1] 0.7239098 0.7245767 0.8981760 0.8981760
}
\references{
Q. Jiang, X. Jin, S.-J. Lee, and S. Yao. A new similarity/distance measure between intuitionistic fuzzy sets based on the transformed isosceles triangles and its applications to pattern recognition. Expert Systems with Applications, 116:439–453, 2019.
}
