% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtd.R
\encoding{UTF-8}
\name{mtd}
\alias{mtd}
\title{Calcul de la performance mtd : month-to-date.}
\usage{
mtd(data, date, m = 0, x, unite = 1, decimal = 0, cumul = FALSE)
}
\arguments{
\item{data}{Un objet de type data.frame contenant au minimum la serie numerique et un vecteur de type date.}

\item{date}{La date jusqu'à laquelle on compte sommer les valeurs au cours du mois.}

\item{m}{Une valeur de type entier qui permet de décaler le mois par rapport à la date introduite. Sa valeur par defaut est \code{0}.}

\item{x}{Un vecteur de type numeric contenant les observations du phénomène à etudier.}

\item{unite}{Un valeur de type numeric, definissant l'ordre d'echelle d'affisage du resultat de la fonction. Sa valeur par defaut est \code{1}.}

\item{decimal}{Un objet de type numeric permettant de préciser le nombre d'entier à afficher après la virgule. Sa valeur par defaut est \code{0}.}

\item{cumul}{Un objet de type logic qui permet d'indiquer si le vecteur \code{x} contient des valeurs cumulées. Sa valeur par defaut est \code{FALSE}.}
}
\value{
Un vecteur de longieur 1.
}
\description{
Cette fonction permet de calculer la somme des valeurs d'une série dans le mois, partant du 1er jour du mois jusqu'à une date du même mois introduit par l'utilisateur.
}
\examples{
# Voir plus d'exemples et d'explication dans la vignette("iperform")

x <- rnorm(222, mean = 50, sd = 6.3)
date <- seq.Date(as.Date("2023-01-01"), by = "day", length.out = 222)
df <- data.frame(date, x)
mtd(df, date = "2023-08-04", x = "x")

}
