% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_interface.R
\name{ip_interface}
\alias{ip_interface}
\alias{ip_interface.default}
\alias{ip_interface.ip_address}
\title{Vector of IP interfaces}
\usage{
ip_interface(...)

\method{ip_interface}{default}(x = character(), ...)

\method{ip_interface}{ip_address}(address, prefix_length, ...)
}
\arguments{
\item{...}{Arguments passed to methods.}

\item{x}{A character vector of IP interfaces, in CIDR notation (IPv4 or IPv6)}

\item{address}{An \code{\link{ip_address}} vector}

\item{prefix_length}{An integer vector}
}
\value{
An S3 vector of class \code{ip_interface}
}
\description{
Construct a vector of IP interfaces.

This hybrid class stores both the host address and the network it is on.
}
\details{
Constructing an \code{ip_interface} vector is conceptually like constructing an
\code{\link{ip_network}} vector, except the host bits are retained.

The \code{ip_interface} class inherits from the \code{\link{ip_address}} class.
This means it can generally be used in places where an \code{\link{ip_address}}
vector is expected. A few exceptions to this rule are:
\itemize{
\item It does not support addition and subtraction of integers
\item It does not support bitwise operations
\item It cannot be compared to \code{\link{ip_address}} vectors
}

The \code{ip_interface} class additionally supports a few functions typically
reserved for \code{\link{ip_network}} vectors: \code{\link[=prefix_length]{prefix_length()}}, \code{\link[=netmask]{netmask()}} and
\code{\link[=hostmask]{hostmask()}}.

For other purposes, you can extract the address and network components using
\code{\link[=as_ip_address]{as_ip_address()}} and \code{\link[=as_ip_network]{as_ip_network()}}.

When comparing and sorting \code{ip_interface} vectors, the network is compared
before the host address.
}
\examples{
# construct from character vector
ip_interface(c("192.168.0.1/10", "2001:db8:c3::abcd/45"))

# construct from address + prefix length objects
ip_interface(ip_address(c("192.168.0.1", "2001:db8:c3::abcd")), c(10L, 45L))

# extract IP address
x <- ip_interface(c("192.168.0.1/10", "2001:db8:c3::abcd/45"))
as_ip_address(x)

# extract IP network (with host bits masked)
as_ip_network(x)
}
\seealso{
\code{vignette("ip-data")}
}
