% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_params_httk_gas_pbtk.R
\name{get_params_httk_gas_pbtk}
\alias{get_params_httk_gas_pbtk}
\title{Get parameters to fit `httk`'s `gas_pbtk` PBPK model}
\usage{
get_params_httk_gas_pbtk(
  data,
  lower_bound = NULL,
  upper_bound = NULL,
  param_units = alist(BW = "kg", Caco2.Pab = "1E-6 cm/s", Caco2.Pab.dist = "1E-6 cm/s",
    Clint = "uL/min/10^6 hepatocytes", Clint.dist = "uL/min/10^6 hepatocytes",
    Clmetabolismc = "L/h/kg BW", Funbound.plasma = "unitless fraction",
    Funbound.plasma.dist = "unitless fraction", Funbound.plasma.adjustment =
    "unitless coefficient", Fabsgut = "fraction", Fhep.assay.correction = "fraction",
    hematocrit = "percent volume RBCs in blood", Kgut2pu = "unitless ratio", Krbc2pu =
    "unitless ratio", kgutabs = "rate (1/hr)", Kkidney2pu = "unitless ratio", 
    
    Klung2pu = "unitless ratio", km =
    "Michaelis-Menten concentration of half-maximal activity", Kmuc2air =
    "unitless ratio", Kliver2pu = "unitless ratio", Krest2pu = "unitless ratio",
    Kblood2air = "unitless ratio", kUrtc = "L/h/kg BW^(3/4)", liver.density = "g/cm^3",
    logHenry = "log10(atmosphers*m^3/mole)", million.cells.per.gliver = "cells/g liver",
    MW = "g/mol", Pow = "octanol:water partition coefficinet", pKa_Donor = "logarithmic",
    pKa_Accept = "logarithmic", MA = "phospholipid:water distribution coefficient", 
    
    Qcardiacc = "L/h/kg BW^(3/4)", Qgfrc = "fraction", Qgutf = "fraction", Qliverf =
    "fraction", Qalvc = "L/h/kg BW^(3/4)", Qkidneyf = "fraction", Qlungf = "fraction",
    Rblood2plasma = "unitless ratio", Vgutc = "L/kg BW", Vliverc = "L/kg BW", Vartc =
    "L/kg BW", Vkidneyc = "L/kg BW", Vlungc = "L/kg BW", vmax =
    "max reaction velocity 1/min", Vmucc = "L/kg BW", Vvenc = "L/kg BW", Vrestc =
    "L/kg BW", KFsummary = "unitless", Fprotein.plasma = "fraction", fabs.oral =
    "fraction", Qgut_ = "fraction", Qintesttransport = "fraction"),
  restrictive = TRUE,
  ...
)
}
\arguments{
\item{data}{The data set to be fitted (e.g. the result of [preprocess_data()])}

\item{lower_bound}{A mapping specified using a call to [alist()],
giving the lower bounds for each variable, as expressions which may include
variables in `data`.}

\item{upper_bound}{A mapping specified using a call to [alist()],
giving the upper bounds for each variable, as expressions which may include
variables in `data`.}

\item{param_units}{A mapping specified using a call to [alist()],
giving the units for each variable, as expressions which may include
variables in `data`.}

\item{restrictive}{A logical value (TRUE or FALSE. Default: FALSE) that says whether the
assumption is that the clearance is restrictive or non-restrictive}

\item{...}{Other parameters that can be specified in `pk_model`.}
}
\value{
A vector of blood or plasma concentration values  corresponding
 to `time`.
}
\description{
Get parameters to fit the `gas_pbtk`
model from the `httk` package (Wambaugh, Schacht, and Ring. 2025).
}
\section{Required parameters}{

These are given by the \link[httk]{parameterize_3comp2} function in `httk`.
Furthermore, they are transformed to a vector during hte prefitting process.
}

\seealso{
Other built-in model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_2comp}()},
\code{\link{auc_flat}()},
\code{\link{auc_httk_gas_pbtk}()},
\code{\link{cp_1comp}()},
\code{\link{cp_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{cp_flat}()},
\code{\link{cp_httk_gas_pbtk}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_2comp}()},
\code{\link{get_params_flat}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()},
\code{\link{get_starts_httk_gas_pbtk}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}

Other httk model functions: 
\code{\link{auc_httk_gas_pbtk}()},
\code{\link{cp_httk_gas_pbtk}()},
\code{\link{get_starts_httk_gas_pbtk}()}

Other model concentration functions: 
\code{\link{cp_1comp}()},
\code{\link{cp_2comp}()},
\code{\link{cp_flat}()},
\code{\link{cp_httk_gas_pbtk}()}
}
\author{
Gilberto Padilla Mercado
}
\concept{built-in model functions}
\concept{httk model functions}
\concept{model concentration functions}
