% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{generate_plots}
\alias{generate_plots}
\title{Plot Analysis and Forecast Result}
\usage{
generate_plots(analysis_forecast_result)
}
\arguments{
\item{analysis_forecast_result}{Analysis/forecast result from \code{decompose_volume()} or \code{forecast_volume()}.}
}
\value{
A list of \code{patchwork} objects:
       \itemize{
       \item{\code{components}: }{Plot of components of intraday volume;}
       \item{\code{log_components}: }{Plot of components of intraday volume in their log10 scale;}
       \item{\code{original_and_smooth} / \code{original_and_forecast}: }{Plot of the original and the smooth/forecast intraday volume.}}
}
\description{
Generate plots for the analysis and forecast results.
}
\examples{
library(intradayModel)
data(volume_aapl)
volume_aapl_training <- volume_aapl[, 1:20]
volume_aapl_testing <- volume_aapl[, 21:50]

# obtain analysis and forecast result
model_fit <- fit_volume(volume_aapl_training, fixed_pars = list(a_mu = 0.5, var_mu = 0.05),
                        init_pars = list(a_eta = 0.5))
analysis_result <- decompose_volume(purpose = "analysis", model_fit, volume_aapl_training)
forecast_result <- forecast_volume(model_fit, volume_aapl_testing)

# plot the analysis and forecast result
generate_plots(analysis_result)
generate_plots(forecast_result)

}
\author{
Shengjie Xiu, Yifan Yu and Daniel P. Palomar
}
