% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputFunctions.R
\name{igToPNG}
\alias{igToPNG}
\title{Exports Interaction graph to a PNG file}
\usage{
igToPNG(ig, path = "", fName = "InteractionGraph", h = 2000)
}
\arguments{
\item{ig}{Interaction graph}

\item{path}{The folder in which to write the PNG file;}

\item{fName}{The name of the file to be created; "InteractionGraph" by
default}

\item{h}{Desired height of the image in pixels; 2000px by default}
}
\value{
Writes the \code{ig} interaction graph to a PNG (\code{.png}) file
  to the folder specified in the \code{path}
}
\description{
Exports Interaction graph to a PNG file
}
\examples{
#create temp dir path with slashes
myDir <- gsub("\\\\\\\\", "/", tempdir())

#create interaction graph
g <- interactionGraph(golf, "Play", intNo = 10)

#write to PNG
igToPNG(g, path = myDir, fName = "MyGraph", h = 2000)
}
