% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_data_.R
\name{inspect_data_categorical}
\alias{inspect_data_categorical}
\title{Validate categorical data}
\usage{
inspect_data_categorical(data, allow_nas = TRUE, warning_nas = FALSE)
}
\arguments{
\item{data}{An arbitrary object.}

\item{allow_nas}{Logical value. If \code{TRUE} then \code{NA} and \code{NaN} values in
\code{data} are allowed. If \code{FALSE}, execution is stopped and an error message is
thrown in case there are \code{NA} or \code{NaN} values in \code{data}.}

\item{warning_nas}{Logical value. If \code{TRUE} then the presence of \code{NA} or
\code{NaN} values in \code{data} generates a warning message. \code{NA} and \code{NaN} values
pass silently otherwise (if \code{allow_nas} is set to\code{TRUE}).}
}
\value{
\code{inspect_data_categorical} does not return any output. There are
three possible outcomes:
\itemize{
\item The call is silent if:
\itemize{
\item \code{data} is eligible to have been generated by a Multinomial distribution
and there are no \code{NA} or \code{NaN} values in \code{data}.
\item \code{data} is eligible to have been generated by a Multinomial distribution,
there are some \code{NA} or \code{NaN} values in \code{data} and \code{warning_nas} is set to
\code{FALSE}.
}
\item An informative warning message is thrown if: \code{data} is eligible to have
been generated by a Multinomial distribution, there are some \code{NA} or \code{NaN}
values in \code{data} and \code{warning_nas} is set to \code{TRUE}.
\item An informative error message is thrown and the execution is stopped if:
\itemize{
\item \code{data} is not eligible to have been generated by a Multinomial
distribution.
\item \code{data} is eligible to have been generated by a Multinomial distribution,
there are some \code{NA} or \code{NaN} values in \code{data} and \code{allow_nas} is set to
\code{TRUE}.
}
}
}
\description{
\code{inspect_data_categorical} checks if an object contains data
that is eligible to have been generated by a Multinomial distribution. This
can be useful to validate inputs in user-defined functions.
}
\details{
\code{inspect_data_categorical} conducts a series of tests to check if
\code{data} is eligible to have been generated by a Multinomial distribution.
Namely, \code{inspect_data_categorical} checks if:
\itemize{
\item \code{data} is \code{NULL} or empty.
\item \code{data} is atomic and have an eligible data type (logical, integer, double,
character).
\item \code{data} has \code{NA} or \code{NaN} values.
}
}
\examples{
# Calls that pass silently:
x1 <- c(1, 0, 0, 1, 2)
x2 <- c(FALSE, FALSE, TRUE, NA)
x3 <- c("yes", "no", "yes", "maybe")
x4 <- factor(c("yes", "no", "yes", "maybe"))
x5 <- c(1, 0, 0, 1, 0, NA, 2)
inspect_data_categorical(x1)
inspect_data_categorical(x2)
inspect_data_categorical(x3)
inspect_data_categorical(x4)
inspect_data_categorical(x5)
inspect_data_categorical(x5)

# Call that throws an informative warning message:
y1 <- c(1, 1, NA, 0, 0, 2)
try(inspect_data_categorical(y1, warning_nas = TRUE))

# Calls that throw an informative error message:
z <- c(1, 1, NA, 0, 0, 2)
try(inspect_data_categorical(z, allow_nas = FALSE))
try(inspect_data_categorical(NULL))
try(inspect_data_categorical(list(1, 0)))
try(inspect_data_categorical(numeric(0)))
try(inspect_data_categorical(NaN))
try(inspect_data_categorical(NA))
}
\seealso{
\itemize{
\item \code{\link[inspector]{inspect_data_cat_as_dichotom}} to validate
categorical data as dichotomous.
\item \code{\link[inspector]{inspect_par_multinomial}} to validate vectors of
Multinomial proportions.
\item \code{\link[inspector]{inspect_data_dichotomous}} to validate dichotomous
data.
\item \code{\link[inspector]{inspect_par_bernoulli}} to validate
Bernoulli/Binomial proportions.
}
}
