% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_subset.R
\name{in_subset}
\alias{in_subset}
\alias{\%[in{}\%}
\alias{\%[out{}\%}
\alias{\%[in[]\%}
\alias{\%[out[]\%}
\alias{\%[in()\%}
\alias{\%[out()\%}
\alias{\%[in(]\%}
\alias{\%[out(]\%}
\alias{\%[in[)\%}
\alias{\%[out[)\%}
\alias{\%[in~\%}
\alias{\%[out~\%}
\alias{\%[in~p\%}
\alias{\%[out~p\%}
\alias{\%[in~f\%}
\alias{\%[out~f\%}
\alias{\%[in\%}
\alias{\%[out\%}
\alias{\%[in#\%}
\alias{\%[out#\%}
\title{Subsetting Values and Intervals}
\usage{
x \%[in{}\% table

x \%[out{}\% table

x \%[in[]\% interval

x \%[out[]\% interval

x \%[in()\% interval

x \%[out()\% interval

x \%[in(]\% interval

x \%[out(]\% interval

x \%[in[)\% interval

x \%[out[)\% interval

x \%[in~\% pattern

x \%[out~\% pattern

x \%[in~p\% pattern

x \%[out~p\% pattern

x \%[in~f\% pattern

x \%[out~f\% pattern

x \%[in\% table

x \%[out\% table

x \%[in#\% count

x \%[out#\% count
}
\arguments{
\item{x}{vector or array of values to be matched.}

\item{table}{vector or list to be matched against.}

\item{interval}{numeric vector defining a range to be matched against.}

\item{pattern}{pattern to be matched against.}

\item{count}{numeric vector defining counts for count-based selection.}
}
\value{
elements of \code{x} matched by the used infix operator type.
}
\description{
Operators for subsetting values within a given interval or set.
}
\details{
For each \code{\%[*\%} operator of this package \code{x \%[*\% y} is a shorthand for
\code{x[x \%*\% y]}.
}
\examples{
# interval subsetting operators
x <- 1:10
x \%[in[]\% c(3,7)
x \%[in[)\% c(3,7)
x \%[out[)\% c(3,7)

# regular expression subsetting operators
carnames <- rownames(mtcars)
carnames \%[in~\% "^Mazda"
carnames \%[in~\% c("^Mazda", "^Merc")
carnames \%[in~\% c("\\\\w{10,100}$")  # long car names

# count-based subsetting operators
mtcars$cyl \%[in#\% 1:10
mtcars$cyl \%[out#\% 1:10

}
\seealso{
\code{\%in{}\%}
}
