% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_detect.R
\name{in_detect}
\alias{in_detect}
\alias{\%in{}\%}
\alias{\%out{}\%}
\alias{\%in[]\%}
\alias{\%out[]\%}
\alias{\%in()\%}
\alias{\%out()\%}
\alias{\%in(]\%}
\alias{\%out(]\%}
\alias{\%in[)\%}
\alias{\%out[)\%}
\alias{\%in~\%}
\alias{\%out~\%}
\alias{\%in~p\%}
\alias{\%out~p\%}
\alias{\%in~f\%}
\alias{\%out~f\%}
\alias{\%in#\%}
\alias{\%out#\%}
\title{Matching Values and Intervals}
\usage{
x \%in{}\% table

x \%out{}\% table

x \%in[]\% interval

x \%out[]\% interval

x \%in()\% interval

x \%out()\% interval

x \%in(]\% interval

x \%out(]\% interval

x \%in[)\% interval

x \%out[)\% interval

x \%in~\% pattern

x \%out~\% pattern

x \%in~p\% pattern

x \%out~p\% pattern

x \%in~f\% pattern

x \%out~f\% pattern

x \%in#\% count

x \%out#\% count
}
\arguments{
\item{x}{vector or array of values to be matched.}

\item{table}{vector or list to be matched against.}

\item{interval}{numeric vector defining a range to be matched against.}

\item{pattern}{pattern to be matched against.}

\item{count}{numeric vector defining counts for count-based selection.}
}
\value{
a logical vector or an array of the same dimensions as \code{x}
indicating if each value of \code{x} is within the defined subset.
}
\description{
Operators for detecting which values are within a given interval or set.
}
\details{
Compared with default \code{\%in\%} implementation in R the operators implemented here try to be more consistent with other default infix operators like \code{==} and \code{<}.
In particular they preserve the dimensions and the missing values (see examples).

Style of parentheses define the type of matching template:
\itemize{
\item \code{\%in{}\%} detects which elements of \code{x} are present in the set given by the \code{table} argument.
\item \code{\%in()\%}, \code{\%in[]\%}, \code{\%in(]\%} and \code{\%in[)\%} detect the elements of \code{x} included in a range of \code{interval} argument, using \code{range(interval)}.
This range being closed, open on both sides, open on the left, or open on the right, respectively.
\item \code{\%in~\%}, \code{\%in~p\%} and \code{\%in~f\%} detect the elements of \code{x} that match the regular expression given by \code{pattern}.
They wrap \code{grepl()} with the default parameters of \code{perl = TRUE}, and with \code{fixed = TRUE}, respectively.
\item \code{\%in#\%} detects the elements that occur a specified number of times.
Operators of the form \code{\%out<suffix>\%} return the negation of \code{\%in<suffix>\%}
}
}
\examples{
# difference in behaviour with dimensions when compared to \%in\%
iris[1:10,] \%in\% "setosa"
iris[1:10,] == "setosa"
iris[1:10,] \%in{}\% "setosa"

# difference in behaviour with missing values when compared to \%in\%
x <- c(1,2,3,NA,4)
x \%in\% c(1,2,3)
x \%in{}\% c(1,2,3)

# other interval oparators
x <- 1:10
x \%in[]\% c(3,7)
x \%in()\% c(3,7)
x \%in(]\% c(3,7)
x \%in[)\% c(3,7)
x \%out[]\% c(3,7)

# when more than 2 numbers are provided for the interval - range is used
x <- 1:10
all.equal(x \%in[]\% c(2,4), x \%in[]\% c(2,3,4))
all.equal(x \%in[]\% c(2,4), x \%in[]\% range(c(2,3,4)))

# matching according to regular expressions
iris$Species \%in~\% "^v"
iris$Species \%in~f\% "^v"
iris$Species \%in~f\% "versicolor"
iris$Species \%in~f\% c("versicolor", "virginica")

# selecting by number of occurances
mtcars$gear \%in#\% 1:5
mtcars$gear \%out#\% 1:5

}
\seealso{
\code{\%in\%}
}
