% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{bru_response_size}
\alias{bru_response_size}
\alias{bru_response_size.default}
\alias{bru_response_size.inla.surv}
\alias{bru_response_size.bru_obs}
\alias{bru_response_size.bru_obs_list}
\alias{bru_response_size.bru_info}
\alias{bru_response_size.bru}
\title{Response size queries}
\usage{
bru_response_size(object)

\method{bru_response_size}{default}(object)

\method{bru_response_size}{inla.surv}(object)

\method{bru_response_size}{bru_obs}(object)

\method{bru_response_size}{bru_obs_list}(object)

\method{bru_response_size}{bru_info}(object)

\method{bru_response_size}{bru}(object)
}
\arguments{
\item{object}{An object from which to extract response size(s).}
}
\value{
An \code{integer} vector.
}
\description{
Extract the number of response values from \code{bru} and related objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{bru_response_size(default)}: Extract the number of observations from an
object supporting \code{NROW()}.

\item \code{bru_response_size(inla.surv)}: Extract the number of observations from an
\code{inla.surv} object.

\item \code{bru_response_size(bru_obs)}: Extract the number of observations from a
\code{bru_obs} object.

\item \code{bru_response_size(bru_obs_list)}: Extract the number of observations from a
\code{bru_obs_list} object, as a vector with one value per observation model.

\item \code{bru_response_size(bru_info)}: Extract the number of observations from a
\code{bru_info} object, as a vector with one value per observation model.

\item \code{bru_response_size(bru)}: Extract the number of observations from a
\code{bru} object, as a vector with one value per observation model.

}}
\examples{
bru_response_size(
  bru_obs(y ~ 1, data = data.frame(y = rnorm(10)), family = "gaussian")
)
}
\seealso{
\code{\link[=like]{like()}}
}
